#-*- coding: utf8 -*-
"""
@Author       : Weiye Shao
@Creation Time: 2024/10/24 17:05:32

"""
import datetime
from operator import truediv

from numpy import mean
import numpy as np
import tkinter as tk
import pandas as pd
from tkinter import filedialog,messagebox
import datetime
from dateutil.relativedelta import relativedelta
import xlwt
import time


root = tk.Tk()
root.withdraw()

#Get the path of the earthquake catalog file
messagebox.showinfo("Prompt","Select the earthquake catalog data file")
f_path2 = filedialog.askopenfilename()

print('\nThe selected earthquake catalog file is:',f_path2)

#Get the path of the data file
messagebox.showinfo("Prompt","Select the data file")
f_path1 = filedialog.askopenfilename()
file_name =  f_path1[f_path1.rfind('/')+1:f_path1.find('.txt')]
print('\nThe selected data file is:',f_path1)


#Set free parameters
p1=1.01
p3=1.01

p2 = 6
p4 = 1.5
l_p1 = p4 * p1
l_p3 = p4 * p3


#Determine whether the earthquake occurs within 45 days after the alarm
def chang_p(alarm_time,  f_path=f_path2):
    p5 = 1.6
    eqs_time = []
    result0 = []
    start_time = alarm_time

    #Extract the occurrence date from the excel format earthquake catalog file
    eqs=pd.read_excel(f_path, header = 0, usecols=['date','lon.','lat.','Ms','location'])
    eqs_time = pd.to_datetime(eqs['date'].values, format='%Y%m%d')
    eqs_lon = eqs['lon.'].values
    eqs_lat = eqs['lat.'].values
    eqs_Ms = eqs['Ms'].values
    eqs_location = eqs['location'].values

    end_time1 = start_time+datetime.timedelta(days=45)

    for i in range(len(eqs_time)):
        if start_time <= eqs_time[i] <= end_time1:
            result0.append([alarm_time,eqs_time[i],eqs_lat[i],eqs_lon[i],eqs_Ms[i],eqs_location[i]])
    if len(result0) == 0:
        return None
    else:
        b = [i[4] for i in result0]
        c = max(b)
        end_time2 = alarm_time+datetime.timedelta(days=int(p5**c))
        return start_time, end_time2, result0



#Extract data from the txt file into a list
time_list = []
Rn_list = []
with open(f_path1,'r') as f:
    lines = f.readlines()
f.close()
for line in lines:   
    time = line.split( )[0]
    Rn = line.split( )[1]    
    time_list.append(time)
    Rn_list.append(Rn)
    #time_list = list(map(int, time_list))

#Convert data format
Rn_list = list(map(float, Rn_list))
time_list = pd.to_datetime(time_list, format='%Y%m%d')
#print(Rn_list)
#print(time_list)

RnAvg15_list = []
for i in range(0, len(Rn_list)):
    avg = 0
    if i == 0:
        avg = Rn_list[i]
    elif i == 1:
        avg = (Rn_list[i - 1] + Rn_list[i]) / 2
    elif i == 2:
        avg = (Rn_list[i - 2] + Rn_list[i - 1] + Rn_list[i]) / 3
    elif i == 3:
        avg = (Rn_list[i - 3] + Rn_list[i - 2] + Rn_list[i - 1] + Rn_list[i]) / 4
    else:
        avg = (Rn_list[i - 4] + Rn_list[i - 3] + Rn_list[i - 2] + Rn_list[i - 1] + Rn_list[i]) / 5
    RnAvg15_list.append(avg)
    sj = time_list[i].strftime("%Y%m%d")
    pj = str(avg)
    with open(f'C:/Users/86183/Desktop/ceshi/'+file_name+'平均值.xlsx', 'a', encoding='utf-8') as f:
        f.write(sj+"\t"+pj+"\n")
    # print(RnAvg15_list)


while p1 < 1.02:
    while p3 < 1.03:
        # Identify anomalies/warnings
        start_T = 19700101
        end_T = 19700101
        start = pd.to_datetime(start_T, format='%Y%m%d')
        end = pd.to_datetime(end_T, format='%Y%m%d')

        result = []
        for i in range(0, (len(RnAvg15_list) - p2)):
            sj = time_list[i].strftime("%Y-%m-%d")
            # if sj =="2020-01-30":
            #      print(sj)


            if start <= time_list[i +p2] <= end:
                # print ("Within the time window proportional to the seismic moment")
                if RnAvg15_list[i + p2] > (l_p3 * RnAvg15_list[i]):
                    # print(time_list[i+p2])
                    rst = chang_p(time_list[i + p2])
                    if rst is not None:
                        start_T, end_T, result0 = chang_p(time_list[i + p2])
                        result.extend(result0)
                        start = start_T
                        end = end_T
            else:
                aa = Rn_list[i]
                bb = p1 * RnAvg15_list[i - 1]
                if Rn_list[i] > (p1 * RnAvg15_list[i - 1]):
                    # print (time_list[i])
                    if RnAvg15_list[i + p2] > (p3 * RnAvg15_list[i]):
                        # print (time_list[i+p2])
                        rst = chang_p(time_list[i + p2])
                        if rst is None:
                            # print("No earthquake occurred within 45 days after the warning")
                            aa = time_list[i + p2]
                            result.append([time_list[i + p2], "No earthquake occurred within 45 days after the warning", None, None, None, None])
                        else:
                            start_T, end_T, result0 = chang_p(time_list[i + p2])
                            result.extend(result0)
                            start = start_T
                            end = end_T

                            # Create an excel document to save the results
        f = xlwt.Workbook('encoding = utf-8')
        sheet1 = f.add_sheet('sheet1', cell_overwrite_ok=True)
        # if p1==1.01 and p3==1.08:
        #     print("p1:"+str(p1)+";p3:"+str(p3))
        result1 = pd.DataFrame(result, columns=['Warning Time', 'Earthquake Time', 'Longitude', 'Latitude','Magnitude','Earthquake Location'])
        # output_dir = filedialog.askdirectory(title="Select the result saving path")
        f_result_path0 = f'C:/Users/86183/Desktop/ceshi/'+file_name+'Anomaly Identification Results(p1-'+str(p1)+')(p3-'+str(p3)+').xlsx'
        writer = pd.ExcelWriter(f_result_path0)

        result1.to_excel(writer, sheet_name="Calculation Results", index=False)
        writer.close()
        p3 = p3 +0.01
    p3 = 1.01
    p1 = p1 + 0.01

